<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace JchOptimize\Platform;

defined('_WP_EXEC') or die('Restricted access');

use JchOptimize\Core\Helper;

class Paths implements \JchOptimize\Interfaces\PathsInterface
{

        /**
         * 
         * @param type $url
         * @return type
         */
        public static function absolutePath($url)
        {
                return str_replace(array('/', '\\'), DIRECTORY_SEPARATOR, self::rootPath()) . 
                        ltrim(str_replace(array('/', '\\'), DIRECTORY_SEPARATOR, $url), '\\/');
        }

        /**
         * 
         * @return type
         */
        public static function assetPath($pathonly=FALSE)
        {
                if($pathonly)
                {
                        return self::rewriteBase() . 'jch-optimize/assets';
                }
                
                return plugins_url() . '/jch-optimize/assets';
        }

        /**
         * 
         * @return type
         */
        public static function rewriteBase()
        {
                static $rewrite_base;

                if (!isset($rewrite_base))
                {
                        $uri = Uri::getInstance(plugins_url());
                        $rewrite_base = trailingslashit($uri->toString(array('path')));
                }

                return $rewrite_base;
        }

        /**
         * 
         * @return type
         */
        public static function spriteDir($url = FALSE)
        {
                if ($url)
                {
                        return self::rewriteBase() . 'jch-optimize/media/sprites/';
                }

                return JCH_PLUGIN_DIR . 'media/sprites';
        }

        /**
         * 
         * @param type $sPath
         */
        public static function path2Url($sPath)
        {
                $oUri        = clone Uri::getInstance();
                $sBaseFolder = Helper::getBaseFolder();

		$abspath = str_replace(DIRECTORY_SEPARATOR, '/', self::rootPath()); 
                $sPath   = str_replace(DIRECTORY_SEPARATOR, '/', $sPath);

                $sUriPath = $oUri->toString(array('scheme', 'user', 'pass', 'host', 'port')) . $sBaseFolder .
                        (str_replace($abspath, '', $sPath));

                return $sUriPath;
        }

        /**
         * 
         * @param type $function
         * @return type
         */
        public static function ajaxUrl($function)
        {
                return add_query_arg(array('action' => $function), admin_url('admin-ajax.php'));
        }
        
        /**
         * 
         * @return type
         */
        public static function rootPath()
        {
                return ABSPATH;
        }

        /**
         * 
         * @param type $name
         */
        public static function adminController($name)
        {
                return add_query_arg(array('jch-task' => $name), admin_url('options-general.php?page=jchoptimize-settings'));
        }

        /**
         * 
         */
        public static function backupImagesParentFolder()
        {
		$wp_filesystem = Cache::getWPFileSystem();

                return $wp_filesystem->wp_content_dir();
        }

	/**
	 *
	 */
	public static function cachePath($rootrelative=true)
	{
		$wp_filesystem = Cache::getWPFileSystem();

		if($rootrelative)
		{
			return content_url() . '/cache/jch-optimize';
		}
		else
		{
			return untrailingslashit(JCH_CACHE_DIR);
		}

	}

}
